/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetNumberField;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntry;
import org.cyclops.integrateddynamics.core.client.gui.WidgetTextFieldDropdown;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerPartSettings;

public class ContainerScreenPartSettings<T extends ContainerPartSettings>
extends ContainerScreenExtended<T> {
    private WidgetNumberField numberFieldUpdateInterval = null;
    private WidgetNumberField numberFieldPriority = null;
    private WidgetNumberField numberFieldChannel = null;
    private WidgetTextFieldDropdown<Direction> dropdownFieldSide = null;
    private List<SideDropdownEntry> dropdownEntries;

    public ContainerScreenPartSettings(T container, Inventory inventory, Component title) {
        super(container, inventory, title);
    }

    protected void onSave() {
        try {
            if (this.isFieldSideEnabled()) {
                Direction selectedSide = this.dropdownFieldSide.getSelectedDropdownPossibility() == null ? null : this.dropdownFieldSide.getSelectedDropdownPossibility().getValue();
                int side = selectedSide != null && selectedSide != this.getDefaultSide() ? selectedSide.ordinal() : -1;
                ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.m_6262_()), (int)((ContainerPartSettings)this.m_6262_()).getLastSideValueId(), (int)side);
            }
            if (this.isFieldUpdateIntervalEnabled()) {
                int updateInterval = this.numberFieldUpdateInterval.getInt();
                ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.m_6262_()), (int)((ContainerPartSettings)this.m_6262_()).getLastUpdateValueId(), (int)updateInterval);
            }
            if (this.isFieldPriorityEnabled()) {
                int priority = this.numberFieldPriority.getInt();
                ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.m_6262_()), (int)((ContainerPartSettings)this.m_6262_()).getLastPriorityValueId(), (int)priority);
            }
            if (this.isFieldChannelEnabled()) {
                int channel = this.numberFieldChannel.getInt();
                ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.m_6262_()), (int)((ContainerPartSettings)this.m_6262_()).getLastChannelValueId(), (int)channel);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integrateddynamics", "textures/gui/part_settings.png");
    }

    protected Direction getCurrentSide() {
        return ((ContainerPartSettings)this.m_6262_()).getTarget().getTarget().getSide();
    }

    protected Direction getDefaultSide() {
        return ((ContainerPartSettings)this.m_6262_()).getTarget().getCenter().getSide().m_122424_();
    }

    protected String getSideText(Direction side) {
        return side.m_7912_().toLowerCase(Locale.ENGLISH);
    }

    public void m_7856_() {
        super.m_7856_();
        this.getMinecraft().f_91068_.m_90926_(true);
        if (this.isFieldSideEnabled()) {
            this.dropdownEntries = Arrays.stream(Direction.values()).map(x$0 -> new SideDropdownEntry((Direction)x$0)).collect(Collectors.toList());
            this.dropdownFieldSide = new WidgetTextFieldDropdown(this.f_96547_, this.f_97735_ + 106, this.f_97736_ + this.getFieldSideY(), 70, 14, (Component)new TranslatableComponent("gui.integrateddynamics.partsettings.side"), true, Sets.newHashSet(this.dropdownEntries));
            this.setSideInDropdownField(this.getCurrentSide());
            this.dropdownFieldSide.m_94199_(15);
            this.dropdownFieldSide.m_94194_(true);
            this.dropdownFieldSide.m_94202_(0xFFFFFF);
            this.dropdownFieldSide.m_94190_(true);
        }
        if (this.isFieldUpdateIntervalEnabled()) {
            this.numberFieldUpdateInterval = new WidgetNumberField(this.f_96547_, this.f_97735_ + 106, this.f_97736_ + this.getFieldUpdateIntervalY(), 70, 14, true, (Component)new TranslatableComponent("gui.integrateddynamics.partsettings.update_interval"), true);
            this.numberFieldUpdateInterval.m_94199_(15);
            this.numberFieldUpdateInterval.m_94194_(true);
            this.numberFieldUpdateInterval.m_94202_(0xFFFFFF);
            this.numberFieldUpdateInterval.m_94190_(true);
            this.numberFieldUpdateInterval.setMinValue(((ContainerPartSettings)this.container).getLastMinUpdateValue());
        }
        if (this.isFieldPriorityEnabled()) {
            this.numberFieldPriority = new WidgetNumberField(this.f_96547_, this.f_97735_ + 106, this.f_97736_ + this.getFieldPriorityY(), 70, 14, true, (Component)new TranslatableComponent("gui.integrateddynamics.partsettings.priority"), true);
            this.numberFieldPriority.setPositiveOnly(false);
            this.numberFieldPriority.m_94199_(15);
            this.numberFieldPriority.m_94194_(true);
            this.numberFieldPriority.m_94202_(0xFFFFFF);
            this.numberFieldPriority.m_94190_(true);
        }
        if (this.isFieldChannelEnabled()) {
            this.numberFieldChannel = new WidgetNumberField(this.f_96547_, this.f_97735_ + 106, this.f_97736_ + this.getFieldChannelY(), 70, 14, true, (Component)new TranslatableComponent("gui.integrateddynamics.partsettings.channel"), true);
            this.numberFieldChannel.setPositiveOnly(false);
            this.numberFieldChannel.m_94199_(15);
            this.numberFieldChannel.m_94194_(true);
            this.numberFieldChannel.m_94202_(0xFFFFFF);
            this.numberFieldChannel.m_94190_(true);
            this.numberFieldChannel.m_94186_(this.isChannelEnabled());
        }
        TranslatableComponent save = new TranslatableComponent("gui.integrateddynamics.button.save");
        this.m_142416_((GuiEventListener)new ButtonText(this.f_97735_ + 178, this.f_97736_ + 8, this.f_96547_.m_92724_(save.m_7532_()) + 6, 16, (Component)save, (Component)save, this.createServerPressable("button_save", b -> this.onSave()), true));
        this.refreshValues();
    }

    protected int getFieldSideY() {
        return 9;
    }

    protected int getFieldUpdateIntervalY() {
        return 34;
    }

    protected int getFieldPriorityY() {
        return 59;
    }

    protected int getFieldChannelY() {
        return 84;
    }

    protected boolean isFieldSideEnabled() {
        return true;
    }

    protected boolean isFieldUpdateIntervalEnabled() {
        return true;
    }

    protected boolean isFieldPriorityEnabled() {
        return true;
    }

    protected boolean isFieldChannelEnabled() {
        return true;
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (!(this.isFieldUpdateIntervalEnabled() && this.numberFieldUpdateInterval.m_5534_(typedChar, keyCode) || this.isFieldPriorityEnabled() && this.numberFieldPriority.m_5534_(typedChar, keyCode) || this.isFieldChannelEnabled() && this.numberFieldChannel.m_5534_(typedChar, keyCode) || this.isFieldSideEnabled() && this.dropdownFieldSide.m_5534_(typedChar, keyCode))) {
            return super.m_5534_(typedChar, keyCode);
        }
        return true;
    }

    public boolean m_7933_(int typedChar, int keyCode, int modifiers) {
        if (typedChar != 256) {
            if (this.isFieldSideEnabled() && this.dropdownFieldSide.m_7933_(typedChar, keyCode, modifiers)) {
                return true;
            }
            if (this.isFieldUpdateIntervalEnabled() && this.numberFieldUpdateInterval.m_7933_(typedChar, keyCode, modifiers)) {
                return true;
            }
            if (this.isFieldPriorityEnabled() && this.numberFieldPriority.m_7933_(typedChar, keyCode, modifiers)) {
                return true;
            }
            if (this.isFieldChannelEnabled() && this.numberFieldChannel.m_7933_(typedChar, keyCode, modifiers)) {
                return true;
            }
            return true;
        }
        return super.m_7933_(typedChar, keyCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.isFieldSideEnabled() && this.dropdownFieldSide.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.isFieldUpdateIntervalEnabled() && this.numberFieldUpdateInterval.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.isFieldPriorityEnabled() && this.numberFieldPriority.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.isFieldChannelEnabled() && this.numberFieldChannel.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        if (this.isFieldUpdateIntervalEnabled()) {
            this.f_96547_.m_92883_(matrixStack, L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.update_interval", (Object[])new Object[0]), (float)(this.f_97735_ + 8), (float)(this.f_97736_ + this.getFieldUpdateIntervalY() + 3), Helpers.RGBToInt((int)0, (int)0, (int)0));
            this.numberFieldUpdateInterval.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }
        if (this.isFieldPriorityEnabled()) {
            this.f_96547_.m_92883_(matrixStack, L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.priority", (Object[])new Object[0]), (float)(this.f_97735_ + 8), (float)(this.f_97736_ + this.getFieldPriorityY() + 3), Helpers.RGBToInt((int)0, (int)0, (int)0));
            this.numberFieldPriority.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }
        if (this.isFieldChannelEnabled()) {
            this.f_96547_.m_92883_(matrixStack, L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.channel", (Object[])new Object[0]), (float)(this.f_97735_ + 8), (float)(this.f_97736_ + this.getFieldChannelY() + 3), this.isChannelEnabled() ? Helpers.RGBToInt((int)0, (int)0, (int)0) : Helpers.RGBToInt((int)100, (int)100, (int)100));
            this.numberFieldChannel.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }
        if (this.isFieldSideEnabled()) {
            this.f_96547_.m_92883_(matrixStack, L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.side", (Object[])new Object[0]), (float)(this.f_97735_ + 8), (float)(this.f_97736_ + this.getFieldSideY() + 3), Helpers.RGBToInt((int)0, (int)0, (int)0));
            this.dropdownFieldSide.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        if (!this.isChannelEnabled()) {
            GuiHelpers.renderTooltip((AbstractContainerScreen)this, (PoseStack)matrixStack, (int)8, (int)87, (int)100, (int)20, (int)mouseX, (int)mouseY, () -> Lists.newArrayList((Object[])new Component[]{new TranslatableComponent("gui.integrateddynamics.partsettings.channel.disabledinfo")}));
        }
    }

    protected boolean isChannelEnabled() {
        return GeneralConfig.energyConsumptionMultiplier > 0;
    }

    protected int getBaseXSize() {
        return 214;
    }

    protected int getBaseYSize() {
        return 191;
    }

    protected void setSideInDropdownField(Direction side) {
        this.dropdownFieldSide.selectPossibility(this.dropdownEntries.get(side.ordinal()));
    }

    public void onUpdate(int valueId, CompoundTag value) {
        if (this.isFieldSideEnabled() && valueId == ((ContainerPartSettings)this.m_6262_()).getLastSideValueId()) {
            int side = ((ContainerPartSettings)this.m_6262_()).getLastSideValue();
            this.setSideInDropdownField(side == -1 ? this.getDefaultSide() : Direction.values()[side]);
        }
        if (this.isFieldUpdateIntervalEnabled() && valueId == ((ContainerPartSettings)this.m_6262_()).getLastUpdateValueId()) {
            this.numberFieldUpdateInterval.m_94144_(Integer.toString(((ContainerPartSettings)this.m_6262_()).getLastUpdateValue()));
        }
        if (this.isFieldUpdateIntervalEnabled() && valueId == ((ContainerPartSettings)this.m_6262_()).getLastMinUpdateValueId()) {
            this.numberFieldUpdateInterval.setMinValue(((ContainerPartSettings)this.m_6262_()).getLastMinUpdateValue());
        }
        if (this.isFieldPriorityEnabled() && valueId == ((ContainerPartSettings)this.m_6262_()).getLastPriorityValueId()) {
            this.numberFieldPriority.m_94144_(Integer.toString(((ContainerPartSettings)this.m_6262_()).getLastPriorityValue()));
        }
        if (this.isFieldChannelEnabled() && valueId == ((ContainerPartSettings)this.m_6262_()).getLastChannelValueId()) {
            this.numberFieldChannel.m_94144_(Integer.toString(((ContainerPartSettings)this.m_6262_()).getLastChannelValue()));
        }
    }

    public class SideDropdownEntry
    implements IDropdownEntry<Direction> {
        private final Direction side;

        public SideDropdownEntry(Direction side) {
            this.side = side;
        }

        @Override
        public String getMatchString() {
            return ContainerScreenPartSettings.this.getSideText(this.side);
        }

        @Override
        public MutableComponent getDisplayString() {
            if (ContainerScreenPartSettings.this.getDefaultSide() == this.side) {
                return new TextComponent(this.getMatchString()).m_130940_(ChatFormatting.YELLOW);
            }
            return new TextComponent(this.getMatchString());
        }

        @Override
        public List<MutableComponent> getTooltip() {
            return Collections.emptyList();
        }

        @Override
        public Direction getValue() {
            return this.side;
        }
    }
}

